VERSION 5.00
Begin VB.UserControl ucPanel 
   ClientHeight    =   3600
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   4800
   ControlContainer=   -1  'True
   DefaultCancel   =   -1  'True
   ScaleHeight     =   3600
   ScaleWidth      =   4800
End
Attribute VB_Name = "ucPanel"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'This is a generic Container-Binding (re-usable more than once per Form -
'as well as on any count of Forms throughout your project - able to
'host any kind of "cwWidget-stuff" (a complete Widget-Hierarchy can
'be hosted and rendered in each 'ucPanel'-instance).
'
'Background and reason for this ucPanel-container:
'Any cwWidget-implementation works completely windowless, rendered
'per cairo directly into memory (hence not a single WinAPI-Handle
'gets wasted, neither hWnds, nor hDCs, nor hBmps nor hDIBs - nothing.
'And the implementation of any cwWidget is based on plain VB-Classes,
'which need (only nowadays) about 100Byte per instance - and whilst this
'is not "super-light-weight" for a class-instance (if you compare with
'other languages) - it is however far more lightweight than VBs UserControls -
'in terms of memory - as well as in terms of used WinHandle-Resources.
'
'The benefits of such a lightweight approach are, that you can "stack"
'and reuse the smaller, "base-widget-implementations" (as labels, sliders,
'scrollers, commandbuttons, and textboxes etc.) "without regrets" now -
'by hosting and reusing them within "higher level widgets", to form more
'complex controls.
'
'But back to our ucPanel here...
'The reason such a thing needs to exist is simply, that the windowless
'drawings against a cairo memory-surface (which work pretty fast, as
'you've already seen in the Tutorial-Demos 1-19) are "the one thing" -
'the other thing is, how to bring the rendered Widget-Content onto a
'Window-hDC, after the Widget-Refresh-sequences are finished ... and for
'that we need something like... a Panel <g> which offers such a hDC to us.
'
'Now you will perhaps ask - but, but ... we've already seen something like
'that - already working in the Demos 5-17 of this tutorial (per ucCanvas)...
'Sorry to tell you guys, but the little bit of "mouse-interaction" you saw
'there was peanuts... ;-), just some "little trickery", which worked over
'ucCanvas-MouseEvent-delegation into the dhCairo-ControlPoints-feature.
'The final "beam-up" to the screen (as done in both "connector-controls",
'the ucCanvas as well as this one here) per Window-hDC on a Win-OS is only
'one part of the game.
'
'So, what we need for serious Control-Implementations is a full coupling to
'the underlying Message-System of the "OS-containers" - we need to capture
'all the Events which come-in due to User-Interaction, Key-, Mouse- + Drag- and
'Drop-stuff - and that's the second reason we need such a thing as this
'container(-panel) here.
'
'Ok, the single public property below is everything you need, "to get connected" -
'to the Widget-Engine (cWidgetRoot) - which BTW also implements cWidgetBase -
'(the small W-thingy you can see in all the cwImplementations of this project).
'As the name says - cWidgetRoot is the outer Parent-Widget for all Widgets you
'later on add per WidgetRoot.Widgets.Add ...
'It is relative lightweight too, but offers the full functionality of something
'like a "Windowless-Windowmanager" - only that it is hosted within the bounds
'of a normal VB-Usercontrol (this very ucPanel here).
'This Window-manager is responsible for Event-Delegations into the correct
'(currently focussed) WidgetControls, for Tabbing- and Focus-handling,
'correct delegation of pressed Accelerator-Keys - correct clipping of nested
'Parent/Child-Widgets no matter how deep - in conjunction with the NonClient-
'and ClientArea-handling + correct MouseCoord-Translations (which need to start
'at Zero within each Widgets-ClientArea-TopLeftCorner - and not at least -
'with an efficient mechanism to determine, how deep the Redrawing-Queue
'needs to "go back" - in case one of the Widgets forces an Redraw of itself
'per W.Refresh (how deep the Refresh-Manager goes back, depends on different
'factors - if the Widget fills in a rectangular area completely with a
'solid color, if alphatransparency is used or not, what the current overlapping-
'state is with other widgets, if a W.Move was done, or if a dragging takes place.
'
'Sounds complicated, and wasn't easy - but the remaining code-volume (after
'my fourth rewrite <g>) is now pretty small (I'm sure you know these: "why on
'earth didn't you come up with that already on your first try"-thoughts...)

'Anyways, here it is now - a capable and vector-based Widget-Engine for VBClassic
'driven by a great OpenSource-Library (cairo) - and comparable in functionality
'(after some stuff I yet plan to add to dhCairo.dll) to .NETs new WPF-Controls -
'or with other large GUI-Frameworks as GTK+, QT or wxWidgets.
'
'And I'll keep my words, to open up the sources of dhRichClient3.dll and dhCairo.dll
'later on this year under LGPL (and yes, I know - that was proposed already for the
'end of 2009, but this was a real "stressy" year for me with regards to my normal work)...
'Just give me some more time for internal cleanup and perfection ... since I'm someone
'who throws away already working implementations pretty fast, when a more promising
'approach is in sight - this is perhaps a bit contra-productive in an already opened-up
'and large community-project, so please - let me cleanup and perfect some darker
'or yet unfinished corners here and there - this framework here needs to carry a whole
'lot of stuff in the future, so it needs to be as clean and "wellthought" as possible,
'with stable! COM-interfaces (which is just another problem with VB-COM-driven
'community-projects) -
'will inform you when I feel, that the right time for the LGPL-opening of these
'Base-Libraries comes - this will also be the point in time, when the work on the
'new Compiler-project (having a "Visual-IDE" from the very beginning") can start.

Public Property Get WidgetRoot() As cWidgetRoot
Static mWidgetRoot As cWidgetRoot

  If mWidgetRoot Is Nothing Then 'let's create the Root-Object and hold it
    Set mWidgetRoot = New cWidgetRoot
    mWidgetRoot.RenderContentIn Me
  End If

  Set WidgetRoot = mWidgetRoot
End Property

'the above is the real important Property - the thing below is just for convenience,
'so that you can type (in a hosting form):
'ucPanel.Widgets.Add ...
'instead of:
'ucPanel.WidgetRoot.Widgets.Add ...
Public Property Get Widgets() As cWidgets
  Set Widgets = WidgetRoot.Widgets
End Property

